<?php 
include 'header.php';
include 'sidebar.php';
?>
<div class="main-panel">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">DAFTAR REFERRAL</h4>
                    </div>
                    <div class="card-body">
                      <?php
include 'config/koneksi.php';
session_start();

if (isset($_GET['cuid'])) {
    $cuid = $_GET['cuid'];

    // Menangani perubahan status klaim
    if (isset($_POST['ubah_status'])) {
        $userID = $_POST['userID'];
        $newStatus = ($_POST['current_status'] == 0) ? 1 : 0;

        $updateSql = "UPDATE tb_user SET claim = $newStatus WHERE username = '$userID'";
        if (!$conn->query($updateSql)) {
            echo "<script>alert('Error: " . $conn->error . "');</script>";
        }
    }

    // Query data pengguna dari referral
    $sql = "SELECT u.*, 
                   IFNULL(SUM(t.total), '-') AS total_transaksi,
                   IFNULL(MIN(t.date), '-') AS tanggal_transaksi_pertama,
                   IFNULL(MAX(t.date), '-') AS tanggal_transaksi_terakhir,
                   IFNULL(u.claim, 0) AS claim
            FROM tb_user u
            LEFT JOIN tb_transaksi t ON u.cuid = t.userID AND t.jenis = 1 AND t.status = 1
            WHERE u.referral_user_id = '$cuid'
            GROUP BY u.cuid";

    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        echo "<div class='table-responsive'>";
        echo "<table id='example' class='table table-bordered'>";
        echo "<thead class='thead-light'>";
        echo "<tr>
                <th>Username</th>
                <th>Klaim</th>
                <th>Deposit</th>
                <th>Total Transaksi</th>
                <th>Tanggal Transaksi Pertama</th>
                <th>Tanggal Transaksi Terakhir</th>
                <th>Aksi</th>
              </tr>";
        echo "</thead><tbody>";

        while ($row = $result->fetch_assoc()) {
            $username = htmlspecialchars($row["username"]);
            $claim = $row["claim"];
            $total = $row["total_transaksi"];
            $tgl1 = $row["tanggal_transaksi_pertama"];
            $tgl2 = $row["tanggal_transaksi_terakhir"];

            // Klaim status
            $klaimText = ($claim == 1) ? "Sudah Diklaim" : "Belum diklaim";
            $klaimColor = ($claim == 1) ? "green" : "red";

            // Deposit status
            $deposit = ($total !== '-') ? "Sudah" : "Belum";
            $depositColor = ($deposit === "Sudah") ? "green" : "red";
            $totalFormatted = ($total !== '-') ? "Rp " . number_format($total, 0, ',', '.') : "-";

            echo "<tr>";
            echo "<td>$username</td>";
            echo "<td style='color: $klaimColor; font-weight: bold;'>$klaimText</td>";
            echo "<td style='color: $depositColor; font-weight: bold;'>$deposit</td>";
            echo "<td style='color: $depositColor; font-weight: bold;'>$totalFormatted</td>";
            echo "<td style='color: $depositColor; font-weight: bold;'>" . ($tgl1 !== '-' ? $tgl1 : "-") . "</td>";
            echo "<td style='color: $depositColor; font-weight: bold;'>" . ($tgl2 !== '-' ? $tgl2 : "-") . "</td>";

            // Tombol aksi
            echo "<td>
                    <form method='post'>
                        <input type='hidden' name='userID' value='$username'>
                        <input type='hidden' name='current_status' value='$claim'>
                        <button type='submit' name='ubah_status' class='btn btn-sm btn-primary'>"
                        . ($claim == 1 ? "Batalkan Klaim" : "Klaim") .
                        "</button>
                    </form>
                  </td>";
            echo "</tr>";
        }

        echo "</tbody></table></div>";
    } else {
        echo "<p class='alert alert-warning'>Tidak ada data pengguna dalam referral_user_id.</p>";
    }
} else {
    echo "<p class='alert alert-danger'>CUID tidak tersedia di URL.</p>";
}

$conn->close();
?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Menambahkan file CSS DataTables -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

<!-- Menambahkan script DataTables -->
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        $('#example').DataTable();
    });
</script>
